<?php

namespace Illuminate\Foundation\Auth;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Carbon;
use App\User;
use App\Userlog;
use App\Loginhour;
use App\DailyAccessMonitoring;

trait AuthenticatesUsers
{
    use RedirectsUsers, ThrottlesLogins;

    /**
     * Show the application's login form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLoginForm()
    {
        return view('auth.login');
    }

    /**
     * Handle a login request to the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response|\Illuminate\Http\JsonResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function login(Request $request)
    {
        $this->validateLogin($request);

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if (method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {
             $Userlog = new Userlog();
            $Userlog->user_id = Auth::user()->id;
            $Userlog->loged_in_at = date('Y-m-d H:i:s');
            $Userlog->save();

            $User = User::where('id', Auth::user()->id)->first();
            $count=$User->logincount+1;      
            User::where('id', Auth::user()->id)->update(array('logincount'=>$count));        
           $q1=DailyAccessMonitoring::where(['user_id'=>Auth::user()->id])->whereDate('created_at', Carbon::today())->get();
        if($q1->count() > 0){
         
          $total_login=$q1[0]->total_login + 1;
          $data =array('total_login'=>$total_login);
          DailyAccessMonitoring::where(['user_id'=>Auth::user()->id])
          ->whereDate('created_at', Carbon::today())->update($data);
        }else{
        
          $data=array('user_id'=>Auth::user()->id,'total_login'=>1);
          DailyAccessMonitoring::create($data);
        }


            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    /**
     * Validate the user login request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return void
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    protected function validateLogin(Request $request)
    {
        $request->validate([
            $this->username() => 'required|string',
            'password' => 'required|string',
        ]);
    }

    /**
     * Attempt to log the user into the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return bool
     */
    protected function attemptLogin(Request $request)
    {
        return $this->guard()->attempt(
            $this->credentials($request), $request->filled('remember')
        );
    }

    /**
     * Get the needed authorization credentials from the request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    protected function credentials(Request $request)
    {
        return $request->only($this->username(), 'password');
    }

    /**
     * Send the response after the user was authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    protected function sendLoginResponse(Request $request)
    {
        $request->session()->regenerate();

        $this->clearLoginAttempts($request);

        return $this->authenticated($request, $this->guard()->user())
                ?: redirect()->intended($this->redirectPath());
    }

    /**
     * The user has been authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function authenticated(Request $request, $user)
    {
        //
    }

    /**
     * Get the failed login response instance.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    protected function sendFailedLoginResponse(Request $request)
    {
        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);
    }

    /**
     * Get the login username to be used by the controller.
     *
     * @return string
     */
    public function username()
    {
        return 'email';
    }

    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function logout(Request $request)
    {
       $Userlog = Userlog::where('loged_in_at', '>=', date('Y-m-d H:i:s', time()-86400))
              ->whereNull('loged_out_at')
              ->where('user_id', '=', Auth::user()->id)
              ->orderBy('loged_in_at', 'desc')->first();
        if($Userlog) {
          $Userlog->loged_out_at = date('Y-m-d H:i:s');
          $Userlog->save();
          $hours = strtotime($Userlog->loged_out_at) - strtotime($Userlog->loged_in_at);
          $hours/= 3600;
          $hours = (double)$hours;
          $LoginHour = LoginHour::where('user_id', '=', Auth::user()->id)->first();
          if(!$LoginHour) {
            $LoginHour = new LoginHour();
            $LoginHour->user_id = Auth::user()->id;
          }
          $LoginHour->hours = (double)$LoginHour->hours + $hours;
          $LoginHour->logincount = $LoginHour->logincount+1;
          $LoginHour->save();
        }
        // DailyAccessMonitoring::update_user_points();

        $this->guard()->logout();

        $request->session()->invalidate();

        return $this->loggedOut($request) ?: redirect('/');
    }

    /**
     * The user has logged out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    protected function loggedOut(Request $request)
    {
        //
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard();
    }
}
