@extends('layouts.admin') 
@section('content')


<div class="nk-content ">
	<div class="container-fluid">
		<div class="nk-content-inner">
			<div class="nk-content-body">
				<div class="nk-block-head-content" style="margin-bottom:20px;">
					<h3 class="nk-block-title page-title">Institutions</h3>
					
				</div><!-- .nk-block-head-content -->
				<div class="nk-block">
					<div class="card card-bordered card-stretch">
                        <div class="card-aside-wrap">
							<div class="card-inner card-inner-lg">
								<form id="" action="{{ url('edit_school') }}/{{$Institutions[0]->id}}" enctype="multipart/form-data">	
								

									<input type="hidden" name="id" value="<?= $Institutions[0]->id ?>">
									<div class="row gy-4">
										<input type="hidden" class="hidden_country" value="<?= $Institutions[0]->country; ?>">
										<div class="col-md-3">
                                            <div class="form-group">
                                                <label class="form-label" for="">Country</label>
                                                <select id="country" class="form-control bfh-countries" data-country="<?= $Institutions[0]->country; ?>" name="country" 
                                                ></select>
                                                <span class="text-danger birth_country_message" style="display:none">Before going to the next step select Country of birth first</span>
                                            </div>
                                        </div>

                                        <div class="col-md-3 commune" @if($Institutions[0]->country != "HT") style="display:none" @endif>
                                            <div class="form-group">
                                                <label class="form-label" for="">Commune</label>
                                                <select id="commune" class="form-control bfh-commune" name="commune" >
                                                	<option value="{{(isset($Institutions[0]->commune)) ? $Institutions[0]->commune : ''}}">{{(isset($Institutions[0]->commune)) ? showcommuneName($Institutions[0]->commune) : ''}}</option>
                                                    @foreach($communes as $commune)
                                                    <option value="{{ $commune->id }}">{{ $commune->commune }}</option>
                                                    @endforeach
                                                </select>
                                                <span class="text-danger birth_commune_message" style="display:none">Before going to the next field select Commune first</span>
                                            </div>
                                        </div>

                                        <div class="col-md-3 state" @if($Institutions[0]->country == "HT") style="display:none" @endif>
                                            <div class="form-group">
                                                <label class="form-label" for="">State/Province</label>
                                                <select class="form-control bfh-states birth-state-focus" data-country="country" data-state="{{ $Institutions[0]->state }}" name="state" ></select>
                                                <span class="text-danger birth_state_message" style="display:none">Before going to the next field select State/Province first</span>
                                            </div>
                                        </div>  
										<div class="col-md-6">
											<div class="form-group">
												<label class="form-label">Institution Name</label>
												<input type="text" class="form-control" placeholder="Institution Name" name="name" value="<?= $Institutions[0]->name ?>" required>
												@if($errors->any())
													<p style="color: red">{{$errors->first()}}</p>
												@endif
											</div>
										</div>
										
										<div class="col-12">
											<input type="submit" class="btn btn-sm btn-primary" value="Update">
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<script type="text/javascript">
    $( document ).ready(function() {
    	hidden_country = $('.hidden_country').value();
        // load countries in bfh-countries
        $('.bfh-countries').bfhcountries({country: ''});
        $('.state').bfhstates({country: 'country', state: ''});
        // $(".commune").hide();
        // $(".school_commune2").hide();
    });
    $(document).on("change","#country",function(){
        haiti=$("#country").val();
        if(haiti=="HT"){
            $(".commune").show();
            $(".state").hide();
        }else{
            $(".commune").hide();
            $("#commune").val(0);
            $(".state").show();
        } 
    })
    function hideHaiti(){
        haiti=$("#country").val();
        if(haiti=="HT"){
            $(".commune").show();
            $(".state").hide();
        }else{
            $(".commune").hide();
            // $("#commune").val("");
            $("#commune").val(0);
            $(".state").show();
        } 
    }
</script>
@endsection